/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.action;

import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.UserAuthUtility;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.LogUtility;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
//import jp.mosp.common.dao.CtAccountDao;
//import jp.mosp.common.dao.MosPUserDao;
import jp.mosp.common.dto.CmAspUserDto;
//import jp.mosp.common.dto.CmUserDto;
//import jp.mosp.common.dto.CtAccountDto;
import jp.mosp.common.dto.MosPUserDto;
import jp.mosp.common.vo.MosPLoginVo;

public class MosPAuthAction extends MosPAction {

	/**
	 * RXgN^
	 */
	public MosPAuthAction() {
		super();
		setNeedUser(false);
		// OCʂł̃ZbVؒf
		setNeedAspUser(false);
		setCheckProcSeq(false);
		setNeedSession(false);
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// p[^̎擾
		MosPLoginVo vo = getInitVo();
		// 
		init(vo);
		// DBRlNV̎擾
		getConnection();
		// F؏
		login(vo);
		// ㏈
		afterProcess();
	}

	protected MosPLoginVo getInitVo() {
		return new MosPLoginVo();
	}

	/**
	 * 
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	protected void init(MosPLoginVo vo) throws Exception {
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.setParams(request);
		// ASP[U[擾(ݒt@CASPݒŔf)
		setAspUser(vo);
		// p[^̑ÓmF
		if (!vo.validate()) {
			// p[^s̏ꍇ
			setVo(vo);
			setUrl(vo.getRetUrl());
			throw new MospException(MospConst.EX_PARAMS_INVALID);
		}		
	}

	/**
	 * ASP[U[擾(ݒt@CASPݒŔf)
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	private void setAspUser(MosPLoginVo vo) throws Exception {
		// ASP[U[擾(ݒt@CASPݒŔf)
		switch (MospUtility.getAspFlag(cfg)) {
		case 0:
		case 1:
			// 0FASP(x[U[:1Av)
			// 1FASP(1[U[:1Av)
			// ASP[U[Zbg(ZbV擾)
			session = request.getSession(false);
			aspUser = (CmAspUserDto)session.getAttribute(MospConst.ATT_ASPUSER);
			BaseVo aspVo = (BaseVo)request.getAttribute(MospConst.ATT_VO);
			// returnUrlݒ
			vo.setRetUrl(aspVo.getRetUrl());
			break;
		case 2:
			// 2FASP
			// ASP[U[Zbg(OCʂł̃ZbVؒf)
			createAspUser();
			break;
		default:
			throw new MospException(MospConst.EX_ASP_PROPERTIES);
		}
	}

	/**
	 * F؏
	 * @param vo OCʂVO
	 */
	/*	
	public void login(MosPLoginVo vo) throws Exception {
		// DBRlNV̎擾
		getConnection();
		// [U[̎擾
		MosPUserDto dto = new MosPUserDto();
		CmUserDto cmUserDto = new CmUserDto();
		dto.setUserId(vo.getUserId());
		cmUserDto.setUserId(vo.getUserId());
		MosPUserDao dao = new MosPUserDao();
		dao.initDao(cfg, cmd, aspUser, cmUserDto, conn);
		dto = dao.findForRegistered(vo.getUserId());
		// AJEg̎擾
		CtAccountDao ctAccountDao;
		CtAccountDto ctAccountDto;
		if (dto != null) {
			// [U[擾łꍇ
			// 폜`FbN
			if (dto.getDeleteFlag() == 1) {
				vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_AUTH_FAILED, ""));
				setVo(vo);
				setUrl(vo.getRetUrl());
				throw new MospException(MospConst.EX_AUTH_DELETED);
			}
			// AJEg̎擾
			ctAccountDao = new CtAccountDao();
			ctAccountDao.initDao(cfg, cmd, aspUser, cmUserDto, conn);
			ctAccountDto = ctAccountDao.findCtAccountForUserId(dto.getUserId());
			if (ctAccountDto == null) {
				// AJEg񂪎擾łȂꍇ
				// AJEg쐬
				ctAccountDto = new CtAccountDto();
				ctAccountDto.setUserId(dto.getUserId());
				ctAccountDto.setAttempt(1);
				ctAccountDao.insert(ctAccountDto);
			} else {
				// AJEg񂪎擾łꍇ
				// OCs񐔊mF
				int maxAttempt = Integer.parseInt(cfg.getProperty(MospConst.PPT_ACC_ATTEMPT));
				if (ctAccountDto.getAttempt() >= maxAttempt) {
					// OCs񐔂ݒl傫ꍇ
					// ĎsC^[omF
					long interval = Long.parseLong(cfg.getProperty(MospConst.PPT_ACC_INTERVAL)) * 1000;
					Date date = new Date(ctAccountDto.getUpdateDate().getTime() + interval);
					if (date.compareTo(new Date()) > 0) {
						// ĎsC^[ooɃOCsꍇ
						// s񐔂̃CNg
						ctAccountDto.incrementAttempt();
						ctAccountDao.update(ctAccountDto);
						commit();
						// AJEgbNO𔭍s
						vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_ACCOUNT_LOCK, ""));
						setVo(vo);
						setUrl(vo.getRetUrl());
						throw new MospException(MospConst.EX_ACCOUNT_LOCK);
					}
				}
			}
		} else {
			// [U[擾łȂꍇ
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_AUTH_FAILED, ""));
			setVo(vo);
			setUrl(vo.getRetUrl());
			throw new MospException(MospConst.EX_AUTH_NOT_EXIST);
		}
		// pX[hɂF
		if (dto.getPassword().equals(MospUtility.getDigest(vo.getPass()))) {
			// Fؐ
			// AJEg̍XV
			ctAccountDto.setAttempt(0);
			ctAccountDao.update(ctAccountDto);
			// [U[̐ݒ
			dto.setPassword("");
			cmUserDto.setUserId(dto.getUserId());
			cmUserDto.setPassword(dto.getPassword());
			cmUserDto.setUserName(dto.getUserName());
			cmUserDto.setCommonCss("");
			cmUserDto.setMospAuthority(dto.getAuthority());
			cmUserDto.setPayrollAuthority("");
			cmUserDto.setZaimuAuthority("");
			cmUserDto.setSalesAuthority("");
			cmUserDto.setExpenseAuthority("");
			cmUserDto.setExt1Authority("");
			cmUserDto.setExt2Authority("");
			cmUserDto.setExt3Authority("");
			cmUserDto.setExt4Authority("");
			cmUserDto.setExt5Authority("");
			cmUserDto.setDeleteFlag(dto.getDeleteFlag());
			this.user = cmUserDto;

			// {擾yѐݒ
			// (sx擾悤ɂ邩́A)

			// Гȍ~OCłȂ悤ɂB
			getInfo(user.getUserId());
			Date entranceDate;
			if (chkExistDto(mKihon)) {
				entranceDate = util.convIntegerDateToDate(mKihon.getNyDate());
			} else if (dto.getAuthority().equals(CommonConst.AUTHORITY_ADMIN)) {
				entranceDate = new Date(0);
			} else {
				entranceDate = null;
			}
			if (!chkExistObject(entranceDate) || (util.getSystemDate().compareTo(entranceDate) < 0)) {
				// OCʂ֖߂
				vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_AUTH_FAILED, ""));
				setVo(vo);
				setUrl(vo.getRetUrl());
				throw new MospException(MospConst.EX_AUTH_FAILED);
			}
		} else {
			// F؎s
			// AJEg̍XV
			ctAccountDto.incrementAttempt();
			ctAccountDao.update(ctAccountDto);
			commit();
			// OCʂ֖߂
			// [U[擾łȂꍇ
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_AUTH_FAILED, ""));
			setVo(vo);
			setUrl(vo.getRetUrl());
			throw new MospException(MospConst.EX_AUTH_FAILED);
		}
		// DBRlNṼR~bg
		commit();
	}
	 */
	protected void login(MosPLoginVo vo) throws Exception {
		UserAuthUtility authUtility = new UserAuthUtility(cfg, cmd, aspUser, conn);
		authUtility.login(vo.getUserId(), vo.getPass());
		// F؂sĂꍇ
		if (authUtility.isErrMessage()) {
			// R~bg
			commit();
			// G[bZ[W̐ݒ
			vo.addErrMessage(MospUtility.getMessage(msg, authUtility.getErrMessageCode(), ""));
			setVo(vo);
			setUrl(vo.getRetUrl());
			throw new MospException(authUtility.getMosPExceptionCode());
		}
		this.user = authUtility.getCmUserDto();
		// ̃y[W֑Jڏ
		setNextPage(getUserInfo(vo.getUserId()), vo);
	}

	/**
	 * y[WJڏ
	 * @param dto			ΏDTO
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	protected void setNextPage(MosPUserDto dto, MosPLoginVo vo) throws Exception {
		// R}hݒ
		String nextCmd = "C1060";
		// pX[hLmF
		int passTerm = getPasswordTerm();
		boolean validPassWord = true;
		// pX[hL߂ĂApX[hύXʂɑJڂB
		// [U[IDƃpX[hꍇApX[hύXʂɑJڂB
		if (isExpirePassWord(passTerm, dto.getUpdateDate())
				|| isDefaultPassWord(dto.getUserId(), vo.getPass())	
		) {
			nextCmd = jp.mosp.common.action.MosPPasswordAction.CMD_PASSWORD_FORCE_CHANGE;
			validPassWord = false;
		}
		// admin̏ꍇCSSƏR}hύX
		if (dto.getAuthority().equals(CommonConst.AUTHORITY_ADMIN) && validPassWord) {
			user.setCommonCss(CommonConst.CSS_ADMIN);
			nextCmd = vo.CMD_MENU_SYSTEM2;
		}
		setNextCmd(nextCmd);
		// T[ubg
		setUrl(MospConst.URL_SRV);
	}

	/**
	 * pX[hL`FbN
	 * @param passTerm		L
	 * @param updateDate	XV
	 * @return
	 * <p>
	 * L𒴉߂trueAłȂꍇfalse
	 * </p>
	 */
	private boolean isExpirePassWord(int passTerm, Date updateDate) {
		if (passTerm > 0 
				&& util.getSystemDate().compareTo(util.addDay(updateDate, passTerm)) > 0
		) {
			return true;
		}
		return false;
	}

	/**
	 * ftHgpX[h`FbN
	 * @param userid			Ώۃ[UID
	 * @param inputPassWord		Ώۓ̓pX[h
	 * @return
	 * <p>
	 * ftHgpX[h̏ꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception
	 */
	private boolean isDefaultPassWord(String userid, String inputPassWord) throws Exception {
		if (MospUtility.getDigest(MospUtility.getDigest(userid))
				.equals(MospUtility.getDigest(inputPassWord))
		) {
			return true;
		}
		return false;
	}

	/**
	 * ㏈
	 */
	protected void afterProcess() {
		// ZbV̍Ď擾
		if (session != null) {
			session.invalidate();
		}
		session = request.getSession(true);
		// [U[Zbg
		session.setAttribute(MospConst.ATT_ASPUSER, aspUser);
		session.setAttribute(MospConst.ATT_USER, user);
		request.setAttribute(MospConst.ATT_USER, user);
		// Oo
		LogUtility.log(request, 4, MospConst.LOG_MOSPINF, MospConst.LOG_MSG_LOGIN);
	}

}
